/* (C) Copyright 2008 Bill Buckels */

/*
   TIME1A.c by bill buckels

   reward module for module 1 of "What Time is It"
   July 1991


*/



#include <stdio.h>
#include <fcntl.h>
#include <prodos.h>
#include <sgtty.h>
#include <device.h>
#include <sysfunc.h>


/* the auxmem (ems) library info */
/* graphics library map for library TIME.RIB */


extern int soundflag;

#define PUT 0    /* action verbs for putimage */
#define GET 1    /* expand as required */
#define P_STIX  2
#define P_BLACK 3
#define P_WHITE 4
#define P_AND   5
#define P_XOR   6


/* musical array created from file ORANGES.SND */
/* array structure is octave, note, duration */
char oranges1[]={
 3,  7,  3,  7,  0,  1,
 3,  4,  3,  7,  0,  1,
 3,  7,  3,  7,  0,  1,    /* oranges and lemons */
 3,  4,  3,  7,  0,  1,
 3,  0,  3,  7,  0,  1,
 3,  2,  1, 7,   0,  1,
 3,  4,  1, 7,   0,  1,
 3,  5,  3, 7,   0,  1,     /* say the bell of st. clements */
 3,  2,  3, 7,   0,  1,
 3,  7,  3, 7,   0,  1,
 3,  4,  3, 7,   0,  1,
 3,  0,  3, 7,   0,  1, 0xff, 0xff, 0xff};


/* play oranges 1 again ... you owe me five farthings    */
/*                      ... say the bells of st. martins */


char oranges2[]={
 3,  2,  3, 7,  0,  1,
 2, 11,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1,
 2, 11,  3, 7,  0,  1,
 2,  7,  3, 7,  0,  1,           /* when will you pay me        */
 2,  9,  1, 7,  0,  1,           /* say the bells of old bailey */
 2, 11,  1, 7,  0,  1,
 3,  0,  3, 7,  0,  1,
 2,  9,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1,
 2, 11,  3, 7,  0,  1,
 2,  7,  3, 7,  0,  1, 0xff, 0xff, 0xff};


char oranges3[]={
 3,  2,  3, 7,  0,  1,
 2, 11,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1,   /* when i grow rich */
 2,  7,  8, 7,  0,  1,   /* say the bells of shore ditch */
 2,  9,  1, 7,  0,  1,
 2, 11,  1, 7,  0,  1,
 3,  0,  3, 7,  0,  1,
 2,  9,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1,
 2,  7,  8, 7,  0,  1, 0xff, 0xff, 0xff};


char oranges4[]={
 3,  7,  3, 7,  0,  1,   /* when will that be */
 3,  4,  3, 7,  0,  1,
 3,  7,  3, 7,  0,  1,
 3,  0,  8, 7,  0,  1,   /* say the bells of step knee */
 3,  2,  1, 7,  0,  1,
 3,  4,  1, 7,  0,  1,
 3,  5,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1,
 3,  7,  3, 7,  0,  1,
 3,  0,  8, 7,  0,  1, 0xff, 0xff, 0xff};


char oranges5[]={              /* I do not know */
 3,  2,  3, 7,  0,  1,
 2, 11,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1,
 2,  7,  8, 7,  0,  1,         /*  says the great bell of bo */
 2,  9,  1, 7,  0,  1,
 2, 11,  1, 7,  0,  1,
 3,  0,  3, 7,  0,  1,
 2,  9,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1,
 2,  7,  8, 7,  0,  1, 0xff, 0xff, 0xff};

char oranges6[]={
 3,  7,  3, 7,  0,  1,
 3,  4,  3, 7,  0,  1,        /* here comes a candle */
 3,  7,  3, 7,  0,  1,
 3,  4,  3, 7,  0,  1,
 3,  0,  3, 7,  0,  1,
 3,  2,  1, 7,  0,  1,
 3,  4,  1, 7,  0,  1,        /* to light you to bed */
 3,  5,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1,
 3,  7,  3, 7,  0,  1,
 3,  0,  8, 7,  0,  1, 0xff, 0xff, 0xff};

/* play oranges 6  again... and here comes a chopper */
/*                      ... to chop off your head    */


/* the auxmem (ems) library info */
/* graphics library map for library TIME.RIB */

/* lib info for character array created from fragment HOURMENU.BOT */
#define HOURMENU_SIZE   7680
#define HOURMENU_WIDTH  40
#define HOURMENU_HEIGHT 192
#define HOURMENU_OFFSET 0

/* lib info for character array created from fragment TIME0A.RAG */
#define TIME0A_SIZE   1296
#define TIME0A_WIDTH  16
#define TIME0A_HEIGHT 81
#define TIME0A_OFFSET 7680

/* lib info for character array created from fragment TIME1A.RAG */
#define TIME1A_SIZE   3276
#define TIME1A_WIDTH  26
#define TIME1A_HEIGHT 126
#define TIME1A_OFFSET 8976

/* lib info for character array created from fragment TIME2A.RAG */
#define TIME2A_SIZE   3264
#define TIME2A_WIDTH  24
#define TIME2A_HEIGHT 136
#define TIME2A_OFFSET 12252

/* lib info for character array created from fragment ELBOW.RAG */
#define ELBOW_SIZE   96
#define ELBOW_WIDTH  4
#define ELBOW_HEIGHT 24
#define ELBOW_OFFSET 15516

/* lib info for character array created from fragment ELBOW2.RAG */
#define ELBOW2_SIZE   96
#define ELBOW2_WIDTH  4
#define ELBOW2_HEIGHT 24
#define ELBOW2_OFFSET 15612

/* lib info for character array created from fragment DOWNPIPE.RAG */
#define DOWNPIPE_SIZE   64
#define DOWNPIPE_WIDTH  4
#define DOWNPIPE_HEIGHT 16
#define DOWNPIPE_OFFSET 15708

/* lib info for character array created from fragment DOWN2.RAG */
#define DOWN2_SIZE   64
#define DOWN2_WIDTH  4
#define DOWN2_HEIGHT 16
#define DOWN2_OFFSET 15772

/* lib info for character array created from fragment SPOUT.RAG */
#define SPOUT_SIZE   496
#define SPOUT_WIDTH  16
#define SPOUT_HEIGHT 31
#define SPOUT_OFFSET 15836

/* lib info for character array created from fragment SPOUT2.RAG */
#define SPOUT2_SIZE   496
#define SPOUT2_WIDTH  16
#define SPOUT2_HEIGHT 31
#define SPOUT2_OFFSET 16332

/* lib info for character array created from fragment WAVE.RAG */
#define WAVE_SIZE   1704
#define WAVE_WIDTH  24
#define WAVE_HEIGHT 71
#define WAVE_OFFSET 16828

/* lib info for character array created from fragment WAVENO.RAG */
#define WAVENO_SIZE   1704
#define WAVENO_WIDTH  24
#define WAVENO_HEIGHT 71
#define WAVENO_OFFSET 18532

/* lib info for character array created from fragment BOTGLAS.RAG */
#define BOTGLAS_SIZE   580
#define BOTGLAS_WIDTH  10
#define BOTGLAS_HEIGHT 58
#define BOTGLAS_OFFSET 20816

/* lib info for character array created from fragment TIME1B.RAG */
#define TIME1B_SIZE   968
#define TIME1B_WIDTH  22
#define TIME1B_HEIGHT 44
#define TIME1B_OFFSET 21396

/* lib info for character array created from fragment TIME1C.RAG */
#define TIME1C_SIZE   968
#define TIME1C_WIDTH  22
#define TIME1C_HEIGHT 44
#define TIME1C_OFFSET 22364

/* lib info for character array created from fragment TIME1D.RAG */
#define TIME1D_SIZE   912
#define TIME1D_WIDTH  16
#define TIME1D_HEIGHT 57
#define TIME1D_OFFSET 23332

/* lib info for character array created from fragment TOPGLAS.RAG */
#define TOPGLAS_SIZE   580
#define TOPGLAS_WIDTH  10
#define TOPGLAS_HEIGHT 58
#define TOPGLAS_OFFSET 24244



ovmain()
{
       int ctr=0;
       while(ctr<8)
       {
          if(ctr%2==0)
          emsputimage(TIME1B_OFFSET,
                      TIME1B_WIDTH,TIME1B_HEIGHT,
                      4,1,PUT);
          else
          emsputimage(TIME1C_OFFSET,
                      TIME1C_WIDTH,TIME1C_HEIGHT,
                      4,1,PUT);

        ctr++;
        if(soundflag)
        {
        switch(ctr)
        {
          case 1:
          case 2:  play(oranges1);break;
          case 3:  play(oranges2);break;
          case 4:  play(oranges3);break;
          case 5:  play(oranges4);break;
          case 6:  play(oranges5);break;
          case 7:
          case 8:  play(oranges6);break;
          }
          }
          else sound(7,0,3);
        }


          emsputimage(TIME1A_OFFSET,
                      TIME1A_WIDTH,TIME1A_HEIGHT,
                      4,1,PUT);


return(0);

}
